from typing import Dict, Any
import json

TOOL_DESCRIPTIONS: Dict[str, Dict] = {
  "TopIQ_FR_tool": {
    "name": "TopIQ_FR_tool",
    "description": "This is a Full-reference IQA model. Best at evaluating:- Blurs (lens blur, motion blur)- Color distortions (color diffusion, color shift, color quantization, color saturation)- Compression (JPEG2000 and JPEG)- Noise (white noise, color component noise, impulse noise, multiplicative noise, denoise artifact)- Brightness change (brighten, darken, mean shift)- Spatial distortions (jitter, non-eccentricity patch, pixelate, otsu quantization, color block)- Sharpness and contrastand brightness changes. Performs best on common distortions in classical image quality benchmarks.",
    "parameters": {
      "type": "object",
      "properties": {
        "reference_image": {
          "type": "string",
          "description": "The reference image in file path or base64 format."
        },
        "distorted_image": {
          "type": "string",
          "description": "The distorted image in file path or base64 format."
        }
      },
      "required": [
        "reference_image",
        "distorted_image"
      ]
    }
  },
  "AHIQ_tool": {
    "name": "AHIQ_tool",
    "description": "This is Full-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "reference_image": {
          "type": "string",
          "description": "The reference image in file path or base64 format."
        },
        "distorted_image": {
          "type": "string",
          "description": "The distorted image in file path or base64 format."
        }
      },
      "required": [
        "reference_image",
        "distorted_image"
      ]
    }
  },
  "FSIM_tool": {
    "name": "FSIM_tool",
    "description": "This is Full-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "reference_image": {
          "type": "string",
          "description": "The reference image in file path or base64 format."
        },
        "distorted_image": {
          "type": "string",
          "description": "The distorted image in file path or base64 format."
        }
      },
      "required": [
        "reference_image",
        "distorted_image"
      ]
    }
  },
  "LPIPS_tool": {
    "name": "LPIPS_tool",
    "description": "This is Full-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "reference_image": {
          "type": "string",
          "description": "The reference image in file path or base64 format."
        },
        "distorted_image": {
          "type": "string",
          "description": "The distorted image in file path or base64 format."
        }
      },
      "required": [
        "reference_image",
        "distorted_image"
      ]
    }
  },
  "DISTS_tool": {
    "name": "DISTS_tool",
    "description": "This is a Full-reference IQA model. Best at evaluating: - Blurs (gaussian blur)",
    "parameters": {
      "type": "object",
      "properties": {
        "reference_image": {
          "type": "string",
          "description": "The reference image in file path or base64 format."
        },
        "distorted_image": {
          "type": "string",
          "description": "The distorted image in file path or base64 format."
        }
      },
      "required": [
        "reference_image",
        "distorted_image"
      ]
    }
  },
  "WaDIQaM_FR_tool": {
    "name": "WaDIQaM_FR_tool",
    "description": "This is Full-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "reference_image": {
          "type": "string",
          "description": "The reference image in file path or base64 format."
        },
        "distorted_image": {
          "type": "string",
          "description": "The distorted image in file path or base64 format."
        }
      },
      "required": [
        "reference_image",
        "distorted_image"
      ]
    }
  },
  "PieAPP_tool": {
    "name": "PieAPP_tool",
    "description": "This is Full-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "reference_image": {
          "type": "string",
          "description": "The reference image in file path or base64 format."
        },
        "distorted_image": {
          "type": "string",
          "description": "The distorted image in file path or base64 format."
        }
      },
      "required": [
        "reference_image",
        "distorted_image"
      ]
    }
  },
  "MS_SSIM_tool": {
    "name": "MS_SSIM_tool",
    "description": "This is Full-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "reference_image": {
          "type": "string",
          "description": "The reference image in file path or base64 format."
        },
        "distorted_image": {
          "type": "string",
          "description": "The distorted image in file path or base64 format."
        }
      },
      "required": [
        "reference_image",
        "distorted_image"
      ]
    }
  },
  "GMSD_tool": {
    "name": "GMSD_tool",
    "description": "This is Full-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "reference_image": {
          "type": "string",
          "description": "The reference image in file path or base64 format."
        },
        "distorted_image": {
          "type": "string",
          "description": "The distorted image in file path or base64 format."
        }
      },
      "required": [
        "reference_image",
        "distorted_image"
      ]
    }
  },
  "SSIM_tool": {
    "name": "SSIM_tool",
    "description": "This is Full-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "reference_image": {
          "type": "string",
          "description": "The reference image in file path or base64 format."
        },
        "distorted_image": {
          "type": "string",
          "description": "The distorted image in file path or base64 format."
        }
      },
      "required": [
        "reference_image",
        "distorted_image"
      ]
    }
  },
  "CKDN_tool": {
    "name": "CKDN_tool",
    "description": "This is Full-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "reference_image": {
          "type": "string",
          "description": "The reference image in file path or base64 format."
        },
        "distorted_image": {
          "type": "string",
          "description": "The distorted image in file path or base64 format."
        }
      },
      "required": [
        "reference_image",
        "distorted_image"
      ]
    }
  },
  "VIF_tool": {
    "name": "VIF_tool",
    "description": "This is Full-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "reference_image": {
          "type": "string",
          "description": "The reference image in file path or base64 format."
        },
        "distorted_image": {
          "type": "string",
          "description": "The distorted image in file path or base64 format."
        }
      },
      "required": [
        "reference_image",
        "distorted_image"
      ]
    }
  },
  "PSNR_tool": {
    "name": "PSNR_tool",
    "description": "This is Full-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "reference_image": {
          "type": "string",
          "description": "The reference image in file path or base64 format."
        },
        "distorted_image": {
          "type": "string",
          "description": "The distorted image in file path or base64 format."
        }
      },
      "required": [
        "reference_image",
        "distorted_image"
      ]
    }
  },
  "VSI_tool": {
    "name": "VSI_tool",
    "description": "This is Full-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "reference_image": {
          "type": "string",
          "description": "The reference image in file path or base64 format."
        },
        "distorted_image": {
          "type": "string",
          "description": "The distorted image in file path or base64 format."
        }
      },
      "required": [
        "reference_image",
        "distorted_image"
      ]
    }
  },
  "QAlign_tool": {
    "name": "QAlign_tool",
    "description": "This is No-reference IQA model.Best at evaluating:- Blurs (gaussian blur, motion blur)- Color distortions (color shift, color quantization, color saturation)- Noise (white noise, color component noise, impulse noise, multiplicative noise)- Brightness change (brighten, darken, mean shift)- Spatial distortions (jitter, otsu quantization)- Sharpness",
    "parameters": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string",
          "description": "The image to be evaluated, either as file path or base64 string."
        }
      },
      "required": [
        "image"
      ]
    }
  },
  "CLIPIQA_tool": {
    "name": "CLIPIQA_tool",
    "description": "This is No-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string",
          "description": "The image to be evaluated, either as file path or base64 string."
        }
      },
      "required": [
        "image"
      ]
    }
  },
  "UNIQUE_tool": {
    "name": "UNIQUE_tool",
    "description": "This is No-reference IQA model.Best at evaluating:- Blurs (lens blur)- Compression (JPEG, JPEG2000)- Noise (denoise artifact)- Spatial distortions (non-eccentricity patch, pixelate, color block)- Contrast",
    "parameters": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string",
          "description": "The image to be evaluated, either as file path or base64 string."
        }
      },
      "required": [
        "image"
      ]
    }
  },
  "HyperIQA_tool": {
    "name": "HyperIQA_tool",
    "description": "This is No-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string",
          "description": "The image to be evaluated, either as file path or base64 string."
        }
      },
      "required": [
        "image"
      ]
    }
  },
  "TReS_tool": {
    "name": "TReS_tool",
    "description": "This is No-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string",
          "description": "The image to be evaluated, either as file path or base64 string."
        }
      },
      "required": [
        "image"
      ]
    }
  },
  "WaDIQaM_NR_tool": {
    "name": "WaDIQaM_NR_tool",
    "description": "This is No-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string",
          "description": "The image to be evaluated, either as file path or base64 string."
        }
      },
      "required": [
        "image"
      ]
    }
  },
  "DBCNN_tool": {
    "name": "DBCNN_tool",
    "description": "This is No-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string",
          "description": "The image to be evaluated, either as file path or base64 string."
        }
      },
      "required": [
        "image"
      ]
    }
  },
  "ARNIQA_tool": {
    "name": "ARNIQA_tool",
    "description": "This is No-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string",
          "description": "The image to be evaluated, either as file path or base64 string."
        }
      },
      "required": [
        "image"
      ]
    }
  },
  "NIMA_tool": {
    "name": "NIMA_tool",
    "description": "This is No-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string",
          "description": "The image to be evaluated, either as file path or base64 string."
        }
      },
      "required": [
        "image"
      ]
    }
  },
  "BRISQUE_tool": {
    "name": "BRISQUE_tool",
    "description": "This is No-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string",
          "description": "The image to be evaluated, either as file path or base64 string."
        }
      },
      "required": [
        "image"
      ]
    }
  },
  "NIQE_tool": {
    "name": "NIQE_tool",
    "description": "This is No-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string",
          "description": "The image to be evaluated, either as file path or base64 string."
        }
      },
      "required": [
        "image"
      ]
    }
  },
  "MANIQA_tool": {
    "name": "MANIQA_tool",
    "description": "This is No-reference IQA model. This tool has no known strengths for any specific distortion",
    "parameters": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string",
          "description": "The image to be evaluated, either as file path or base64 string."
        }
      },
      "required": [
        "image"
      ]
    }
  },
  "LIQE_mix_tool": {
    "name": "LIQE_mix_tool",
    "description": "This is No-reference IQA model.Best at evaluating: - Color distortion (color diffusion)",
    "parameters": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string",
          "description": "The image to be evaluated, either as file path or base64 string."
        }
      },
      "required": [
        "image"
      ]
    }
  }
}



def convert_to_qwen_tool_schema(tool_name: str, info: Dict[str, Any]) -> Dict[str, Any]:
    return {
        "name": tool_name,
        "description": info["description"],
        "parameters": {
            "type": "object",
            "properties": {
                k: {"type": "string", "description": v}
                for k, v in info["args"].items()
            },
            "required": list(info["args"].keys())
        }
    }

# converted_tools = {
#     name: convert_to_qwen_tool_schema(name, desc)
#     for name, desc in TOOL_DESCRIPTIONS.items()
# }
# # converted_tools
# output_path = "converted_tool_descriptions.json"
# with open(output_path, "w", encoding="utf-8") as f:
#     json.dump(converted_tools, f, indent=2, ensure_ascii=False)
